#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static WORD* FrameBuf3d2;
static WORD PosiCos40[256];
static WORD BatonHeight[256];
static WORD BatonCourbe[256];
static WORD BatonDegrade[65536];
static DWORD SinTab2[320];

void Deform3dfx(WORD*, WORD*);

void LInit_Baton()
{
	WORD Red, Green, Blue;
	int Cpt1;

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		PosiCos40[Cpt1] = (WORD)((float)cos((float)Cpt1*PI2/256.f)*50.f+60.f);
		BatonHeight[Cpt1] = (WORD)((float)cos((float)Cpt1*PI2/256.f)*45.f+55.f);
	}

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		BatonCourbe[Cpt1] = (WORD)(256.*acos(1-Cpt1/128.)/PI);
	}
	for(Cpt1=0;Cpt1<65536;Cpt1++)
	{
		Red = Cpt1&63488;
		Green = Cpt1&1984;
		Blue = Cpt1&31;
		if (Red) Red-=2048;
		if (Green) Green-=64;
		if (Blue) Blue--;
		BatonDegrade[Cpt1] = Red | Green | Blue;
		Red = Cpt1&63488;
		Green = Cpt1&1984;
		Blue = Cpt1&31;
		if (Red!=63488) Red+=2048;
		if (Green!=1984) Green+=64;
		if (Blue!=31) Blue++;
	}
	for(Cpt1=0;Cpt1<320;Cpt1++)
	{
		SinTab2[Cpt1] = (DWORD) (sin((float)Cpt1*3.1415927*2./256.)*90.)+166;
	}

}

void QInit_Baton()
{
	grConstantColorValue(128<<24);

	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);

	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	g_TextureBuff.info.format = GR_TEXFMT_RGB_565;

	FrameBuf3d2 = (WORD*)malloc(sizeof(WORD)*65536);
	memset(FrameBuf3d2, 0, 65536*2);
}

void Effect_Baton()
{
	static WORD* pBufferBis;
	static DWORD y1, y2, y1h, y2h;
	static long delta_y1, delta_y2;
	static DWORD Height, HeightText;
	static DWORD err1=0, err2=0, err3=0;
	static DWORD Cpt1, Cpt2;
	static float SinTmp, CosTmp;
	DWORD dwTmp = 0;
	DWORD Img1;

	if (g_demostate.TickInEffect<10500-1000)
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_ONE,
						GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	}
	else
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
						GR_COMBINE_FACTOR_LOCAL,
						GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = (10500-g_demostate.TickInEffect)*256/1000;
		//printf("%d\n", dwTmp);
		dwTmp = CLIP_DW(dwTmp);
		dwTmp = dwTmp|(dwTmp<<8)|(dwTmp<<16);
	}

	Img1 = g_demostate.TickInEffect / 10;

#ifdef WIN32
	__asm{
		push edi
		push eax
		push ecx
		push esi
		push ebx
		xor eax, eax
		mov edi, FrameBuf3d2
		mov esi, OFFSET BatonDegrade
		mov ecx, 65536-256
boucle1:
		mov ax, [edi+512]
		mov bx, [esi+eax*2]
		mov [edi], bx

		add edi, 2
		dec ecx
		jnz boucle1

		pop ebx
		pop esi
		pop ecx
		pop eax
		pop edi
	}
#else
	//this is a good implementation :-)
	__asm__ __volatile__ ("
        pushl %%edi
        pushl %%eax
        pushl %%ecx
        pushl %%esi
        pushl %%ebx

		xorl %%eax, %%eax
        movl %0, %%edi
        movl %1, %%esi
        movl $65280, %%ecx
        xorl %%eax, %%eax
0:
        movw 512(%%edi), %%ax
        movw (%%esi, %%eax, 2), %%bx
        movw %%bx, (%%edi)
        addl $2, %%edi
        decl %%ecx
        jnz 0b

        popl %%ebx
        popl %%esi
        popl %%ecx
        popl %%eax
        popl %%edi"
        :
	: "g" (FrameBuf3d2), "g" (&BatonDegrade[0])
	);

#endif


	Img1+=2;
	y1 = PosiCos40[Img1&255];
	y2 = PosiCos40[(Img1+128)&255];
	y1h = BatonHeight[Img1&255];
	y2h = BatonHeight[(Img1+128)&255];
	delta_y1 = y1 - y2;
	delta_y2 = y1h - y2h;
	pBufferBis = FrameBuf3d2 + y1*256;
//	pBufferBis = (WORD*)g_FrameBuf3d + y1*256;
	Height=y1h;
	err1 =0; err2=0;
	
	if(delta_y1>=0)	// Cas descendant
	{
		for(Cpt1=0;Cpt1<256;Cpt1++)
		{
			HeightText=0; err3=0;
			for(Cpt2=0;Cpt2<Height;Cpt2++)
			{
				*(pBufferBis+Cpt2*256) = *(g_PicBaton3dfx+((Cpt1+Img1)&127)+((BatonCourbe[HeightText&255]+Img1)&255)*128);
				err3 += 256;
				while(err3>=Height)
				{
					err3 -= Height;
					HeightText++;
				}
			}
			err1 += delta_y1;
			err2 += delta_y2;
			if (err1 >= 256)
			{
				err1 -= 256;
				pBufferBis -= 256;
			}
			if (err2 >= 256)
			{
				err2 -= 256;
				Height--;
			}
			pBufferBis++;
		}
	}
	else
	{
		for(Cpt1=0;Cpt1<256;Cpt1++)
		{
			HeightText=0; err3=0;
			for(Cpt2=0;Cpt2<Height;Cpt2++)
			{
				*(pBufferBis+Cpt2*256) = *(g_PicBaton3dfx+((Cpt1+Img1)&127) + ((BatonCourbe[HeightText&255]+Img1)&255)*128);
				err3 += 256;
				while(err3>=Height)
				{
					err3 -= Height;
					HeightText++;
				}
			}
			err1 -= delta_y1;
			err2 -= delta_y2;
			if (err1 >= 256)
			{
				err1 -= 256;
				pBufferBis += 256;
			}
			if (err2 >= 256)
			{
				err2 -= 256;
				Height++;
			}
			pBufferBis++;
		}
	}

	Deform3dfx(FrameBuf3d2, g_FrameBuf3d);

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);

	SelectTexture(g_TextureBuff);

	CosTmp = (float)cos(Img1/160.f);
	SinTmp = (float)sin(Img1/160.f);

	Fond4.tmuvtx[0].tow = Fond1.tmuvtx[0].sow = (128 + 127*SinTmp)/FOND_Z;
	Fond1.tmuvtx[0].tow = Fond2.tmuvtx[0].sow = (128 + 127*CosTmp)/FOND_Z;
	Fond2.tmuvtx[0].tow = Fond3.tmuvtx[0].sow = (128 - 127*SinTmp)/FOND_Z;
	Fond3.tmuvtx[0].tow = Fond4.tmuvtx[0].sow = (128 - 127*CosTmp)/FOND_Z;

	grConstantColorValue(dwTmp|(255<<24));
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	grConstantColorValue(dwTmp|(128<<24));
	Fond4.tmuvtx[0].sow = Fond1.tmuvtx[0].tow = (128 + 127*SinTmp)/FOND_Z;
	Fond1.tmuvtx[0].sow = Fond2.tmuvtx[0].tow = (128 + 127*CosTmp)/FOND_Z;
	Fond2.tmuvtx[0].sow = Fond3.tmuvtx[0].tow = (128 - 127*SinTmp)/FOND_Z;
	Fond3.tmuvtx[0].sow = Fond4.tmuvtx[0].tow = (128 - 127*CosTmp)/FOND_Z;

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

}

void ByeBye_Baton()
{
	free(FrameBuf3d2);
}

void Deform3dfx(WORD* pSrc, WORD* pDst)
{
	static DWORD img3=0;

	img3 = (img3+2)%256;
#ifdef WIN32
	_asm
	{
		push ebp
		mov edi, pDst
		mov esi, pSrc
		mov eax, 256
		xor ecx, ecx		// terme d erreur
BigBoucle:
		mov ebp, img3
		add ebp, eax
		cmp ebp, 256
		jb suite1
		sub ebp, 256
suite1:
		mov ebp, SinTab2[ebp*4]
		push esi
		mov ebx, 256
LittleBoucle:
		add ecx, ebp		// rajoute zoom dans terme d erreur
		cmp ecx, 256
		jb suite2
		sub ecx, 256
		add esi, 2

suite2:
		mov dx, [esi]
		mov [edi], dx
		add edi, 2
		dec ebx
		jnz LittleBoucle

		pop esi
		add esi, 512
		dec eax
		jnz BigBoucle

		pop ebp
	}
#else
	__asm__ volatile("
		pushl %%ebp
		movl %0, %%edi
		movl %1, %%esi
		movl $256, %%eax
		xorl %%ecx, %%ecx		// terme d erreur
BigBoucle:
		movl %2, %%ebp
		addl %%eax, %%ebp
		cmpl $256, %%ebp
		jb suite1
		subl $256, %%ebp
suite1:
		movl SinTab2(,%%ebp, 4), %%ebp
		pushl %%esi
		movl $256, %%ebx
LittleBoucle:
		addl %%ebp, %%ecx		// rajoute zoom dans terme d erreur
		cmpl $256, %%ecx
		jb suite2
		subl $256, %%ecx
		addl $2, %%esi

suite2:
		movw (%%esi), %%dx
		movw %%dx, (%%edi)
		addl $2, %%edi
		decl %%ebx
		jnz LittleBoucle

		popl %%esi
		addl $512, %%esi
		decl %%eax
		jnz BigBoucle

		popl %%ebp"
        :
	: "g" (pDst), "g" (pSrc), "g" (img3), "g" (SinTab2)
	);

#endif
}

